/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco;

import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.github.talrey.createdeco.blocks.VerticalSlabBlock;
import com.github.talrey.createdeco.registry.BrickBuilders;
import com.github.talrey.createdeco.registry.DecoCreativeModeTab;
import com.github.talrey.createdeco.registry.MetalDecoBuilders;
import com.github.talrey.createdeco.registry.Props;
import com.github.talrey.createdeco.registry.SheetMetal;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2389;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class Registration {
    private static final HashMap<class_1767, String> BRICK_COLOR_NAMES = new HashMap();
    private static final HashMap<String, Function<String, class_1792>> DOOR_TYPES = new HashMap();
    public static HashMap<String, Function<String, class_1792>> METAL_TYPES = new HashMap();
    public static ItemEntry<class_1792> WORN_BRICK_ITEM;
    public static HashMap<String, BlockEntry<class_2248>> WORN_BRICK_TYPES;
    public static HashMap<String, BlockEntry<class_2510>> WORN_STAIRS;
    public static HashMap<String, BlockEntry<class_2482>> WORN_SLABS;
    public static HashMap<String, BlockEntry<VerticalSlabBlock>> WORN_VERTS;
    public static HashMap<String, BlockEntry<class_2544>> WORN_WALLS;
    public static HashMap<class_1767, BlockEntry<class_2248>> BRICK_BLOCK;
    public static HashMap<class_1767, BlockEntry<class_2248>> TILE_BRICK_BLOCK;
    public static HashMap<class_1767, BlockEntry<class_2248>> LONG_BRICK_BLOCK;
    public static HashMap<class_1767, BlockEntry<class_2248>> SHORT_BRICK_BLOCK;
    public static HashMap<class_1767, BlockEntry<class_2248>> CRACKED_BRICK_BLOCK;
    public static HashMap<class_1767, BlockEntry<class_2248>> CRACKED_TILE_BLOCK;
    public static HashMap<class_1767, BlockEntry<class_2248>> CRACKED_LONG_BLOCK;
    public static HashMap<class_1767, BlockEntry<class_2248>> CRACKED_SHORT_BLOCK;
    public static HashMap<class_1767, BlockEntry<class_2248>> MOSSY_BRICK_BLOCK;
    public static HashMap<class_1767, BlockEntry<class_2248>> MOSSY_TILE_BLOCK;
    public static HashMap<class_1767, BlockEntry<class_2248>> MOSSY_LONG_BLOCK;
    public static HashMap<class_1767, BlockEntry<class_2248>> MOSSY_SHORT_BLOCK;
    public static HashMap<class_1767, HashMap<String, BlockEntry<class_2510>>> BRICK_STAIRS_BLOCK;
    public static HashMap<class_1767, HashMap<String, BlockEntry<class_2482>>> BRICK_SLAB_BLOCK;
    public static HashMap<class_1767, HashMap<String, BlockEntry<VerticalSlabBlock>>> BRICK_VERT_BLOCK;
    public static HashMap<class_1767, HashMap<String, BlockEntry<class_2544>>> BRICK_WALL_BLOCK;
    public static HashMap<String, BlockEntry<class_2323>> DOOR_BLOCKS;
    public static HashMap<String, BlockEntry<class_2323>> LOCK_DOOR_BLOCKS;
    public static HashMap<String, BlockEntry<class_2389>> BAR_BLOCKS;
    public static HashMap<String, BlockEntry<class_2389>> BAR_PANEL_BLOCKS;
    public static HashMap<String, BlockEntry<class_2354>> MESH_FENCE_BLOCKS;
    public static HashMap<String, BlockEntry<CatwalkBlock>> CATWALK_BLOCKS;
    public static HashMap<class_1767, ItemEntry<class_1792>> BRICK_ITEM;
    public static ItemEntry<class_1792> ZINC_SHEET;
    public static ItemEntry<class_1792> NETHERITE_SHEET;
    public static ItemEntry<class_1792> NETHERITE_NUGGET;
    public static ItemEntry<class_1792> CAST_IRON_NUGGET;
    public static ItemEntry<class_1792> CAST_IRON_INGOT;
    public static ItemEntry<class_1792> CAST_IRON_SHEET;
    public static BlockEntry<class_2248> CAST_IRON_BLOCK;

    public Registration() {
        BRICK_COLOR_NAMES.put(class_1767.field_7963, "Dusk");
        BRICK_COLOR_NAMES.put(class_1767.field_7967, "Pearl");
        BRICK_COLOR_NAMES.put(class_1767.field_7964, "Scarlet");
        BRICK_COLOR_NAMES.put(class_1767.field_7947, "Dean");
        BRICK_COLOR_NAMES.put(class_1767.field_7951, "Blue");
        BRICK_COLOR_NAMES.put(null, "Red");
        DOOR_TYPES.put("Andesite", str -> (class_1792)AllItems.ANDESITE_ALLOY.get());
        DOOR_TYPES.put("Copper", str -> class_1802.field_27022);
        DOOR_TYPES.put("Zinc", str -> (class_1792)AllItems.ZINC_INGOT.get());
        DOOR_TYPES.put("Brass", str -> (class_1792)AllItems.BRASS_INGOT.get());
        METAL_TYPES.put("Andesite", str -> (class_1792)AllItems.ANDESITE_ALLOY.get());
        METAL_TYPES.put("Zinc", str -> (class_1792)AllItems.ZINC_INGOT.get());
        METAL_TYPES.put("Copper", str -> class_1802.field_27022);
        METAL_TYPES.put("Brass", str -> (class_1792)AllItems.BRASS_INGOT.get());
        METAL_TYPES.put("Iron", str -> class_1802.field_8620);
        METAL_TYPES.put("Gold", str -> class_1802.field_8695);
        METAL_TYPES.put("Netherite", str -> class_1802.field_22020);
        METAL_TYPES.put("Cast Iron", str -> (class_1792)CAST_IRON_INGOT.get());
        Props.COIN_TYPES.add("Zinc");
        Props.COIN_TYPES.add("Copper");
        Props.COIN_TYPES.add("Brass");
        Props.COIN_TYPES.add("Iron");
        Props.COIN_TYPES.add("Gold");
        Props.COIN_TYPES.add("Netherite");
        Props.COIN_TYPES.add("Cast Iron");
    }

    public static class_6862<class_1792> makeItemTag(String path) {
        return class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960("c", path));
    }

    private static BlockEntry<?> getBrickFromName(String overlay, class_1767 dye, String shape) {
        if (overlay.trim().equals("Mossy")) {
            return switch (shape.trim()) {
                case "Brick Tiles" -> MOSSY_TILE_BLOCK.get(dye);
                case "Long Bricks" -> MOSSY_LONG_BLOCK.get(dye);
                case "Short Bricks" -> MOSSY_SHORT_BLOCK.get(dye);
                default -> MOSSY_BRICK_BLOCK.get(dye);
            };
        }
        if (overlay.trim().equals("Cracked")) {
            return switch (shape.trim()) {
                case "Brick Tiles" -> CRACKED_TILE_BLOCK.get(dye);
                case "Long Bricks" -> CRACKED_LONG_BLOCK.get(dye);
                case "Short Bricks" -> CRACKED_SHORT_BLOCK.get(dye);
                default -> CRACKED_BRICK_BLOCK.get(dye);
            };
        }
        return switch (shape.trim()) {
            case "Brick Tiles" -> TILE_BRICK_BLOCK.get(dye);
            case "Long Bricks" -> LONG_BRICK_BLOCK.get(dye);
            case "Short Bricks" -> SHORT_BRICK_BLOCK.get(dye);
            default -> BRICK_BLOCK.get(dye);
        };
    }

    public static String getBrickColorName(class_1767 color) {
        return BRICK_COLOR_NAMES.getOrDefault(color, "");
    }

    public static class_1792 getBrickItemFromColor(class_1767 color) {
        return color != null ? (class_1792)BRICK_ITEM.get(color).get() : class_1802.field_8621;
    }

    public static class_2248 getBrickBlockFromColor(class_1767 color) {
        return color != null ? (class_2248)BRICK_BLOCK.get(color).get() : class_2246.field_10104;
    }

    public static class_2248 getBrickStairBlockFromColor(class_1767 color, String suf) {
        if (!(color != null || suf.contains("Tiles") || suf.contains("Short") || suf.contains("Long"))) {
            return class_2246.field_10089;
        }
        return (class_2248)BRICK_STAIRS_BLOCK.get(color).get(suf).get();
    }

    public static class_2248 getBrickSlabBlockFromColor(class_1767 color, String suf) {
        if (!(color != null || suf.contains("Tiles") || suf.contains("Short") || suf.contains("Long"))) {
            return class_2246.field_10191;
        }
        return (class_2248)BRICK_SLAB_BLOCK.get(color).get(suf).get();
    }

    public static class_2248 getBrickWallBlockFromColor(class_1767 color, String suf) {
        if (!(color != null || suf.contains("Tiles") || suf.contains("Short") || suf.contains("Long"))) {
            return class_2246.field_10269;
        }
        return (class_2248)BRICK_WALL_BLOCK.get(color).get(suf).get();
    }

    public static class_2248 getBrickVertBlockFromColor(class_1767 color, String suf) {
        return (class_2248)BRICK_VERT_BLOCK.get(color).get(suf).get();
    }

    public static void registerBlocks(Registrate reg) {
        reg.creativeModeTab(() -> DecoCreativeModeTab.BRICKS_GROUP);
        BlockBuilder wornBrick = BrickBuilders.buildBrick(reg, null, "", "Worn", "Bricks").recipe((ctx, prov) -> class_2447.method_10437((class_1935)((class_1935)ctx.get())).method_10439("bb").method_10439("bb").method_10434(Character.valueOf('b'), (class_1935)WORN_BRICK_ITEM.get()).method_10429("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{(class_1935)WORN_BRICK_ITEM.get()})).method_10431((Consumer)prov));
        WORN_BRICK_TYPES.put("Worn Bricks", (BlockEntry<class_2248>)wornBrick.register());
        String[] prefs = new String[]{"", "Cracked", "Mossy"};
        String[] sufs = new String[]{"Bricks", "Brick Tiles", "Long Bricks", "Short Bricks"};
        for (String pre : prefs) {
            for (String suf : sufs) {
                String full = (String)(pre.equals("") ? "" : pre + " ") + "Worn " + suf;
                if (!pre.equals("") || !suf.equals("Bricks")) {
                    WORN_BRICK_TYPES.put(full, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, null, pre, "Worn", suf).recipe((ctx, prov) -> {
                        prov.stonecutting(DataIngredient.items((NonNullSupplier)wornBrick.get(), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                        if (pre.equals("Cracked")) {
                            prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get("Worn " + suf)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                        }
                    }).register());
                }
                WORN_STAIRS.put(full, (BlockEntry<class_2510>)BrickBuilders.buildBrickStairs(reg, null, pre, "Worn", suf).recipe((ctx, prov) -> {
                    prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                    prov.stairs(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_STAIRS.get("Worn " + suf)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
                WORN_SLABS.put(full, (BlockEntry<class_2482>)BrickBuilders.buildBrickSlabs(reg, null, pre, "Worn", suf).recipe((ctx, prov) -> {
                    prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                    prov.slab(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_SLABS.get("Worn " + suf)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
                WORN_VERTS.put(full, (BlockEntry<VerticalSlabBlock>)BrickBuilders.buildBrickVerts(reg, null, pre, "Worn", suf).recipe((ctx, prov) -> {
                    prov.stonecutting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_BRICK_TYPES.get(full)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                    class_2447.method_10436((class_1935)((class_1935)ctx.get()), (int)3).method_10439("s").method_10439("s").method_10439("s").method_10434(Character.valueOf('s'), (class_1935)WORN_SLABS.get(full).get()).method_10429("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{(class_1935)WORN_SLABS.get(full).get()})).method_10431((Consumer)prov);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_VERTS.get("Worn " + suf)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
                WORN_WALLS.put(full, (BlockEntry<class_2544>)BrickBuilders.buildBrickWalls(reg, null, pre, "Worn", suf).recipe((ctx, prov) -> {
                    prov.wall(DataIngredient.items((class_1935)((class_2248)WORN_BRICK_TYPES.get(full).get()), (class_1935[])new class_2248[0]), (Supplier)ctx);
                    if (pre.equals("Cracked")) {
                        prov.blasting(DataIngredient.items((NonNullSupplier)((NonNullSupplier)WORN_WALLS.get("Worn " + suf)), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 0.5f);
                    }
                }).register());
            }
        }
        BRICK_COLOR_NAMES.forEach((dye, name) -> {
            if (dye != null) {
                BRICK_BLOCK.put((class_1767)dye, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, dye, "", name, "Bricks").recipe((ctx, prov) -> class_2447.method_10437((class_1935)((class_1935)ctx.get())).method_10439("bb").method_10439("bb").method_10434(Character.valueOf('b'), (class_1935)Registration.getBrickItemFromColor(dye)).method_10429("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{Registration.getBrickItemFromColor(dye)})).method_10431((Consumer)prov)).register());
            }
            TILE_BRICK_BLOCK.put((class_1767)dye, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, dye, "", name, "Brick Tiles").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx)).register());
            LONG_BRICK_BLOCK.put((class_1767)dye, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, dye, "", name, "Long Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx)).register());
            SHORT_BRICK_BLOCK.put((class_1767)dye, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, dye, "", name, "Short Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx)).register());
            CRACKED_BRICK_BLOCK.put((class_1767)dye, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, dye, "Cracked", name, "Bricks").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx);
            }).register());
            CRACKED_TILE_BLOCK.put((class_1767)dye, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, dye, "Cracked", name, "Brick Tiles").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((class_1935)((class_2248)TILE_BRICK_BLOCK.get(dye).get()), (class_1935[])new class_2248[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx);
            }).register());
            CRACKED_LONG_BLOCK.put((class_1767)dye, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, dye, "Cracked", name, "Long Bricks").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((class_1935)((class_2248)LONG_BRICK_BLOCK.get(dye).get()), (class_1935[])new class_2248[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx);
            }).register());
            CRACKED_SHORT_BLOCK.put((class_1767)dye, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, dye, "Cracked", name, "Short Bricks").recipe((ctx, prov) -> {
                prov.blasting(DataIngredient.items((class_1935)((class_2248)SHORT_BRICK_BLOCK.get(dye).get()), (class_1935[])new class_2248[0]), (Supplier)ctx, 0.5f);
                prov.stonecutting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx);
            }).register());
            MOSSY_BRICK_BLOCK.put((class_1767)dye, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, dye, "Mossy", name, "Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx)).register());
            MOSSY_TILE_BLOCK.put((class_1767)dye, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, dye, "Mossy", name, "Brick Tiles").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx)).register());
            MOSSY_LONG_BLOCK.put((class_1767)dye, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, dye, "Mossy", name, "Long Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx)).register());
            MOSSY_SHORT_BLOCK.put((class_1767)dye, (BlockEntry<class_2248>)BrickBuilders.buildBrick(reg, dye, "Mossy", name, "Short Bricks").recipe((ctx, prov) -> prov.stonecutting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx)).register());
            HashMap<CallSite, BlockEntry> stair = new HashMap<CallSite, BlockEntry>();
            HashMap<CallSite, BlockEntry> slab = new HashMap<CallSite, BlockEntry>();
            HashMap<CallSite, BlockEntry> vert = new HashMap<CallSite, BlockEntry>();
            HashMap<CallSite, BlockEntry> wall = new HashMap<CallSite, BlockEntry>();
            for (String pre : prefs) {
                for (String suf : sufs) {
                    String full = (String)(pre.equals("") ? "" : pre + " ") + name + " " + suf;
                    if (dye != null || !pre.equals("") || !suf.equals("Bricks")) {
                        stair.put((CallSite)((Object)full), BrickBuilders.buildBrickStairs(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                            prov.stonecutting(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx);
                            prov.stairs(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                            if (pre.equals("Cracked")) {
                                prov.blasting(DataIngredient.items((class_1935)Registration.getBrickStairBlockFromColor(dye, full.substring(8)), (class_1935[])new class_2248[0]), (Supplier)ctx, 0.5f);
                            }
                        }).register());
                        slab.put((CallSite)((Object)full), BrickBuilders.buildBrickSlabs(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                            prov.stonecutting(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, 2);
                            prov.slab(DataIngredient.items(Registration.getBrickFromName(pre, dye, suf), (NonNullSupplier[])new NonNullSupplier[0]), (Supplier)ctx, null, false);
                            if (pre.equals("Cracked")) {
                                prov.blasting(DataIngredient.items((class_1935)Registration.getBrickSlabBlockFromColor(dye, full.substring(8)), (class_1935[])new class_2248[0]), (Supplier)ctx, 0.5f);
                            }
                        }).register());
                        wall.put((CallSite)((Object)full), BrickBuilders.buildBrickWalls(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                            prov.wall(DataIngredient.items((class_1935)((class_2248)Registration.getBrickFromName(pre, dye, suf).get()), (class_1935[])new class_2248[0]), (Supplier)ctx);
                            if (pre.equals("Cracked")) {
                                prov.blasting(DataIngredient.items((class_1935)Registration.getBrickWallBlockFromColor(dye, full.substring(8)), (class_1935[])new class_2248[0]), (Supplier)ctx, 0.5f);
                            }
                        }).register());
                    }
                    vert.put((CallSite)((Object)full), BrickBuilders.buildBrickVerts(reg, dye, pre, name, suf).recipe((ctx, prov) -> {
                        prov.stonecutting(DataIngredient.items((class_1935)Registration.getBrickBlockFromColor(dye), (class_1935[])new class_2248[0]), (Supplier)ctx, 2);
                        class_2447.method_10436((class_1935)((class_1935)ctx.get()), (int)3).method_10439("s").method_10439("s").method_10439("s").method_10434(Character.valueOf('s'), (class_1935)Registration.getBrickSlabBlockFromColor(dye, full)).method_10429("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{Registration.getBrickSlabBlockFromColor(dye, full)})).method_10431((Consumer)prov);
                        if (pre.equals("Cracked")) {
                            prov.blasting(DataIngredient.items((class_1935)Registration.getBrickSlabBlockFromColor(dye, full.substring(8)), (class_1935[])new class_2248[0]), (Supplier)ctx, 0.5f);
                        }
                    }).register());
                }
            }
            BRICK_STAIRS_BLOCK.put((class_1767)dye, (HashMap<String, BlockEntry<class_2510>>)stair);
            BRICK_SLAB_BLOCK.put((class_1767)dye, (HashMap<String, BlockEntry<class_2482>>)slab);
            BRICK_VERT_BLOCK.put((class_1767)dye, (HashMap<String, BlockEntry<VerticalSlabBlock>>)vert);
            BRICK_WALL_BLOCK.put((class_1767)dye, (HashMap<String, BlockEntry<class_2544>>)wall);
        });
        reg.creativeModeTab(() -> DecoCreativeModeTab.METALS_GROUP);
        SheetMetal.registerBlocks(reg);
        DOOR_TYPES.forEach((metal, ingot) -> DOOR_BLOCKS.put(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"), (BlockEntry<class_2323>)MetalDecoBuilders.buildDoor(reg, metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_door", "block/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).lang(metal + " Door").recipe((ctx, prov) -> class_2447.method_10437((class_1935)((class_1935)ctx.get())).method_10439("mm").method_10439("mm").method_10439("mm").method_10434(Character.valueOf('m'), (class_1935)ingot.apply(metal)).method_10429("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{(class_1935)ingot.apply(metal)})).method_10431((Consumer)prov)).register()));
        DOOR_TYPES.forEach((metal, ingot) -> LOCK_DOOR_BLOCKS.put(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"), (BlockEntry<class_2323>)MetalDecoBuilders.buildDoor(reg, "locked_" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_door", "block/locked_" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"), class_3614.field_15953).lang("Locked " + metal + " Door").recipe((ctx, prov) -> class_2450.method_10447((class_1935)((class_1935)ctx.get())).method_10449((class_1935)class_1802.field_8530, 1).method_10449((class_1935)DOOR_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).get(), 1).method_10442("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{DOOR_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).asStack().method_7909()})).method_10431((Consumer)prov)).register()));
        METAL_TYPES.forEach((metal, getter) -> {
            boolean postFlag = metal.contains("Netherite") || metal.contains("Cast Iron");
            BAR_BLOCKS.put(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"), (BlockEntry<class_2389>)MetalDecoBuilders.buildBars(reg, metal.equals("Iron") ? "Polished Iron" : metal, getter, "", postFlag).tag(new class_6862[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).recipe((ctx, prov) -> {
                if (!metal.equals("Iron")) {
                    class_2447.method_10436((class_1935)((class_1935)ctx.get()), (int)16).method_10439("mmm").method_10439("mmm").method_10434(Character.valueOf('m'), (class_1935)getter.apply(metal)).method_10429("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{(class_1935)getter.apply(metal)})).method_10431((Consumer)prov);
                }
                class_2450.method_10447((class_1935)((class_1935)ctx.get())).method_10454((class_1935)BAR_PANEL_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).get()).method_10442("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{(class_1935)BAR_PANEL_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).get()})).method_17972((Consumer)prov, new class_2960("createdeco", metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_bars_from_panel"));
            }).register());
            BAR_PANEL_BLOCKS.put(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"), (BlockEntry<class_2389>)MetalDecoBuilders.buildBars(reg, metal.equals("Iron") ? "Polished Iron" : metal, getter, "overlay", postFlag).lang((metal.equals("Iron") ? "Polished Iron" : metal) + " Panel Bars ").recipe((ctx, prov) -> class_2450.method_10447((class_1935)((class_1935)ctx.get())).method_10454((class_1935)BAR_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).get()).method_10442("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{(class_1935)BAR_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).get()})).method_10431((Consumer)prov)).register());
            if (metal.equals("Iron")) {
                BAR_PANEL_BLOCKS.put("vanilla_iron", (BlockEntry<class_2389>)MetalDecoBuilders.buildBars(reg, metal, getter, "overlay").lang(metal + " Panel Bars").recipe((ctx, prov) -> {
                    class_2450.method_10447((class_1935)((class_1935)ctx.get())).method_10454((class_1935)class_1802.field_8076).method_10442("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{class_1802.field_8076})).method_10431((Consumer)prov);
                    class_2450.method_10447((class_1935)class_1802.field_8076).method_10454((class_1935)ctx.get()).method_10442("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{(class_1935)ctx.get()})).method_17972((Consumer)prov, new class_2960("createdeco", "vanilla_metal_bars_from_panel"));
                }).register());
            }
            MESH_FENCE_BLOCKS.put((String)metal, (BlockEntry<class_2354>)MetalDecoBuilders.buildFence(reg, metal).register());
            CATWALK_BLOCKS.put((String)metal, (BlockEntry<CatwalkBlock>)MetalDecoBuilders.buildCatwalk(reg, metal).register());
        });
        CAST_IRON_BLOCK = reg.block("cast_iron_block", class_2248::new).initialProperties(class_3614.field_15953).properties(props -> props.method_9629(5.0f, 6.0f).method_29292().method_22488().method_9626(class_2498.field_22150)).lang("Block of Cast Iron").simpleItem().register();
        Props.registerBlocks(reg);
    }

    public static void registerItems(Registrate reg) {
        reg.creativeModeTab(() -> DecoCreativeModeTab.BRICKS_GROUP, "CreateDeco Bricks");
        BRICK_COLOR_NAMES.forEach((dye, name) -> {
            if (dye == null) {
                WORN_BRICK_ITEM = reg.item("worn_brick", class_1792::new).recipe((ctx, prov) -> prov.blasting(DataIngredient.items((class_1935)class_1802.field_8621, (class_1935[])new class_1792[0]), (Supplier)ctx, 0.3f)).register();
            } else {
                BRICK_ITEM.put((class_1767)dye, (ItemEntry<class_1792>)reg.item(name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_brick", class_1792::new).lang(name + " Brick").recipe((ctx, prov) -> class_2447.method_10436((class_1935)((class_1935)ctx.get()), (int)8).method_10439("bbb").method_10439("bCb").method_10439("bbb").method_10434(Character.valueOf('b'), (class_1935)class_1802.field_8621).method_10434(Character.valueOf('C'), (class_1935)class_1769.method_7803((class_1767)dye)).method_10429("has_item", (class_184)class_2066.class_2068.method_8959((class_1935[])new class_1935[]{class_1769.method_7803((class_1767)dye)})).method_10431((Consumer)prov)).register());
            }
        });
        reg.creativeModeTab(() -> DecoCreativeModeTab.METALS_GROUP, "CreateDeco Metals");
        ZINC_SHEET = reg.item("zinc_sheet", class_1792::new).tag(new class_6862[]{Registration.makeItemTag("zinc_plates")}).lang("Zinc Sheet").register();
        NETHERITE_SHEET = reg.item("netherite_sheet", class_1792::new).properties(class_1792.class_1793::method_24359).tag(new class_6862[]{Registration.makeItemTag("netherite_plates")}).lang("Netherite Sheet").register();
        NETHERITE_NUGGET = reg.item("netherite_nugget", class_1792::new).properties(class_1792.class_1793::method_24359).tag(new class_6862[]{Registration.makeItemTag("netherite_nuggets")}).lang("Netherite Nugget").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, () -> class_1802.field_22020)).register();
        CAST_IRON_NUGGET = reg.item("cast_iron_nugget", class_1792::new).tag(new class_6862[]{Registration.makeItemTag("cast_iron_nuggets")}).lang("Cast Iron Nugget").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, () -> (class_1792)CAST_IRON_INGOT.get())).register();
        CAST_IRON_INGOT = reg.item("cast_iron_ingot", class_1792::new).tag(new class_6862[]{Registration.makeItemTag("cast_iron_ingots")}).lang("Cast Iron Ingot").recipe((ctx, prov) -> prov.storage((NonNullSupplier)ctx, () -> ((class_2248)CAST_IRON_BLOCK.get()).method_8389())).register();
        CAST_IRON_SHEET = reg.item("cast_iron_sheet", class_1792::new).tag(new class_6862[]{Registration.makeItemTag("cast_iron_plates")}).lang("Cast Iron Sheet").register();
        Props.registerItems(reg);
    }

    static {
        WORN_BRICK_TYPES = new HashMap();
        WORN_STAIRS = new HashMap();
        WORN_SLABS = new HashMap();
        WORN_VERTS = new HashMap();
        WORN_WALLS = new HashMap();
        BRICK_BLOCK = new HashMap();
        TILE_BRICK_BLOCK = new HashMap();
        LONG_BRICK_BLOCK = new HashMap();
        SHORT_BRICK_BLOCK = new HashMap();
        CRACKED_BRICK_BLOCK = new HashMap();
        CRACKED_TILE_BLOCK = new HashMap();
        CRACKED_LONG_BLOCK = new HashMap();
        CRACKED_SHORT_BLOCK = new HashMap();
        MOSSY_BRICK_BLOCK = new HashMap();
        MOSSY_TILE_BLOCK = new HashMap();
        MOSSY_LONG_BLOCK = new HashMap();
        MOSSY_SHORT_BLOCK = new HashMap();
        BRICK_STAIRS_BLOCK = new HashMap();
        BRICK_SLAB_BLOCK = new HashMap();
        BRICK_VERT_BLOCK = new HashMap();
        BRICK_WALL_BLOCK = new HashMap();
        DOOR_BLOCKS = new HashMap();
        LOCK_DOOR_BLOCKS = new HashMap();
        BAR_BLOCKS = new HashMap();
        BAR_PANEL_BLOCKS = new HashMap();
        MESH_FENCE_BLOCKS = new HashMap();
        CATWALK_BLOCKS = new HashMap();
        BRICK_ITEM = new HashMap();
    }
}

